# Taskify – Laravel Framework License Agreement

Copyright © 2025  
Developed & Maintained by **Infinitie Technologies**  
Website: [https://infinitietech.com](https://infinitietech.com)

---

## License

Taskify is distributed under the **MIT License**, allowing you to use, modify, and distribute the software freely, provided that you include the original copyright and license notice.

For details, see [LICENSE](LICENSE).

---

## Third-Party Software

Taskify integrates several third-party libraries, APIs, and frameworks to enhance functionality. Each library is used in compliance with its respective license, and users must adhere to their terms where applicable.

Below is a list of **notable third-party technologies used in Taskify**:

| Component / Service                        | Purpose / Integration Area                 | License / Terms              | Website / Documentation                                  |
|--------------------------------------------|--------------------------------------------|------------------------------|----------------------------------------------------------|
| **Laravel Framework**                      | Core PHP Framework                         | MIT License                  | [Laravel](https://laravel.com) |
| **Laravel Sanctum**                        | API Authentication                         | MIT License                  | [Sanctum](https://laravel.com/docs/sanctum) |
| **Laravel Scout**                          | Full-Text Search                           | MIT License                  | [Scout](https://laravel.com/docs/scout) |
| **Laravel UI**                             | UI Scaffolding                             | MIT License                  | [Laravel UI](https://github.com/laravel/ui) |
| **Laravel Invoices (Laravel Daily)**       | Invoice Management                         | MIT License                  | [Laravel Invoices](https://github.com/LaravelDaily/Laravel-Invoices) |
| **Spatie Laravel MediaLibrary**            | Media Management                           | MIT License                  | [MediaLibrary](https://github.com/spatie/laravel-medialibrary) |
| **Spatie Laravel Permission**              | Roles & Permissions                        | MIT License                  | [Permission](https://github.com/spatie/laravel-permission) |
| **AWS SDK for PHP**                        | AWS Services Integration                   | Apache License 2.0           | [AWS SDK](https://aws.amazon.com/sdk-for-php/) |
| **Barryvdh Laravel DomPDF**                | PDF Generation                             | MIT License                  | [Laravel DomPDF](https://github.com/barryvdh/laravel-dompdf) |
| **Google API Client**                      | Google Services Integration                | Apache License 2.0           | [Google API PHP Client](https://github.com/googleapis/google-api-php-client) |
| **Guzzle HTTP Client**                     | HTTP Requests                              | MIT License                  | [Guzzle](https://github.com/guzzle/guzzle) |
| **League Flysystem AWS S3**                | File Storage                               | MIT License                  | [Flysystem](https://flysystem.thephpleague.com/) |
| **Maatwebsite Excel**                      | Excel Import/Export                        | MIT License                  | [Laravel Excel](https://github.com/Maatwebsite/Laravel-Excel) |
| **Munafio Chatify**                        | Real-Time Messaging                        | MIT License                  | [Chatify](https://github.com/munafio/chatify) |
| **Laravel Cross-Eloquent Search**          | Multi-Model Search                         | MIT License                  | [Cross-Eloquent Search](https://github.com/protonemedia/laravel-cross-eloquent-search) |
| **Laravel Comments**                       | Comment System                             | MIT License                  | [Laravel Comments](https://github.com/ryangjchandler/laravel-comments) |
| **Twilio SDK**                             | Messaging & Communication                  | MIT License                  | [Twilio PHP SDK](https://www.twilio.com/docs/libraries/php) |
| **Alexusmai Laravel File Manager**         | File Management                            | MIT License                  | [Laravel File Manager](https://github.com/alexusmai/laravel-file-manager) |
| **Anhskohbo NoCaptcha**                    | Google reCAPTCHA Integration               | MIT License                  | [Laravel NoCaptcha](https://github.com/anhskohbo/no-captcha) |
| **Silviolleite LaravelPWA**                | Progressive Web App Support                | MIT License                  | [Laravel PWA](https://github.com/silviolleite/laravel-pwa) |
| **Laravel Sail**                           | Docker Environment                         | MIT License                  | [Laravel Sail](https://laravel.com/docs/sail) |
| **Knuckleswtf Scribe**                     | API Documentation                          | MIT License                  | [Scribe](https://github.com/knuckleswtf/scribe) |
| **Laravel Pint**                           | PHP Code Formatter                         | MIT License                  | [Laravel Pint](https://laravel.com/docs/pint) |
| **Laravel Tinker**                         | REPL for Laravel                           | MIT License                  | [Tinker](https://laravel.com/docs/tinker) |
| **Spatie Laravel Ignition**                | Debugging                                  | MIT License                  | [Ignition](https://github.com/spatie/laravel-ignition) |
| **PHPUnit**                                | Testing Framework                          | BSD-3-Clause License         | [PHPUnit](https://phpunit.de) |
| **FakerPHP Faker**                         | Data Generation for Testing                | MIT License                  | [FakerPHP](https://fakerphp.github.io/) |
| **Mockery**                                | Mocking Framework for Testing              | BSD License                  | [Mockery](https://github.com/mockery/mockery) |

> ⚠️ **Note**: Ensure compliance with each library's respective license. Taskify integrates these technologies solely to extend functionality, and Infinitie Technologies does not claim ownership of these third-party libraries.

---

## Usage Terms

By using Taskify, you agree to:

✅ Retain copyright notices.  
✅ Comply with third-party licenses.  
✅ Indemnify Infinitie Technologies against any misuse of the software.  
✅ Acknowledge that Taskify is provided “as-is” without warranty of any kind.

For full details, refer to the [MIT License](LICENSE).

---

## Contact

📧 **Infinitie Technologies**  
🌐 [https://infinitietech.com](https://infinitietech.com)

---

Thank you for choosing **Taskify** to streamline your project and team management workflow.
