# Taskify - Project & Task Management System 

Taskify is a **powerful Laravel-based Project & Task Management System** that helps you organize projects, manage teams, and streamline workflows effortlessly within your organization. 

It combines **clean design, deep insights, and robust functionality** to keep your projects, tasks, and teams aligned for optimal productivity.

---

## ✨ Features

### 📊 Elegant and Informative Dashboard
- A clean, aesthetically pleasing dashboard offering **project, task, and productivity metrics at a glance**.
- Instantly view **team member birthdays, work anniversaries, and leave information**, keeping you connected with your team like never before.

### 🗂️ Projects
- Manage projects from **inception to completion** with intuitive tools.
- Use **tags, deadlines, budgets**, and custom statuses to stay organized and on track.
- Duplicate projects with ease for recurring workflows.

### ✅ Tasks
- Break down projects into **manageable tasks with deadlines** and progress tracking.
- Use **custom statuses** for tasks to match your workflow.
- Duplicate tasks quickly to maintain consistency and save time.

### 🗨️ Real-time Chat
- Built-in chat with **live notifications (Pusher-supported)** to foster seamless team communication within projects.

### 📅 Meetings
- Schedule and conduct **virtual meetings directly** within Taskify.
- Keep all discussions tied to relevant projects and tasks in one organized space.

### 🏢 Workspaces
- Create **dedicated workspaces for teams or departments**.
- Enhance organization and collaboration within or across organizations.

### 👥 Users & Custom Roles
- Manage users effortlessly, controlling who can access what.
- Define **custom roles and permissions** to match your team's structure.

### 🧑‍💼 Clients
- Maintain a structured **client database with project links**, improving client relationship management.

### 📄 Contracts
- Store and manage **project contracts securely** within the system.

### 💰 Payslips
- Automate **payslip creation and distribution**, simplifying your payroll processes.

### 🌍 Multi-Language Support
- Reach your global team with **multi-language support** for localized experiences.

### 📝 Notes & 📋 Todos
- Keep project-related notes centralized for better documentation and knowledge sharing.
- Create and track **to-do lists** for yourself and team members, ensuring clear accountability.

### 🏖️ Leave Requests
- Integrated system for **submitting, approving, and tracking leave requests** seamlessly.

### ⚙️ Customizable Settings
- Fully customizable platform allowing you to tailor Taskify to your unique workflows and preferences.

### 🔄 Auto-update System Updater
- Keep your system updated with **automatic updates**, ensuring you always have the latest features and security improvements.

### ♻️ Duplicate Items with Ease
- Effortlessly duplicate **projects, tasks, meetings, contracts, and payslips** with just a few clicks, simplifying repetitive workflows.

---

## 🛠️ Tech Stack

- **Laravel 11.x+**
- MySQL / MariaDB
- Blade (Bootstrap 5 styling)
- jQuery for dynamic interactions
- ApexCharts for rich dashboards
- Pusher for real-time notifications
- Spatie Permissions for RBAC

---

