<?php $__env->startSection('title'); ?>
    <?php echo e(get_label('pwa_settings', 'PWA Settings')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="container-fluid">
        <div class="d-flex justify-content-between mb-2 mt-4">

            <div>
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb breadcrumb-style1">
                        <li class="breadcrumb-item">
                            <a href="<?php echo e(url('home')); ?>"><?php echo e(get_label('home', 'Home')); ?></a>
                        </li>
                        <li class="breadcrumb-item">
                            <span><?php echo e(get_label('settings', 'Settings')); ?></span>
                        </li>
                        <li class="breadcrumb-item active">
                            <?php echo e(get_label('pwa_settings', 'PWA Settings')); ?>

                        </li>
                    </ol>
                </nav>
            </div>
        </div>


        <div class="card rounded-4 border-0 shadow-sm">
            <div class="card-body p-4">
                <h4 class="fw-bold mb-4"><?php echo e(get_label('pwa_settings', 'PWA Settings')); ?></h4>

                <?php if(session('success')): ?>
                    <div class="alert alert-success alert-dismissible fade show rounded-3" role="alert">
                        <?php echo e(session('success')); ?>

                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                <?php endif; ?>

                <form method="POST" action="<?php echo e(route('pwa-settings.update')); ?>" enctype="multipart/form-data"
                    class="needs-validation" novalidate data-original-name="<?php echo e($pwaSettings['name'] ?? 'Taskify'); ?>"
                    data-original-short-name="<?php echo e($pwaSettings['short_name'] ?? 'Taskify'); ?>"
                    data-original-theme-color="<?php echo e($pwaSettings['theme_color'] ?? '#000000'); ?>"
                    data-original-background-color="<?php echo e($pwaSettings['background_color'] ?? '#ffffff'); ?>"
                    data-original-description="<?php echo e($pwaSettings['description'] ?? 'A task management app to boost productivity'); ?>">

                    <?php echo csrf_field(); ?>

                    <div class="row g-4">
                        
                        <div class="col-md-6">
                            <label class="form-label fw-medium" for="name">Name <span
                                    class="text-danger">*</span></label>
                            <input type="text" name="name" id="name" class="form-control rounded-3"
                                value="<?php echo e(old('name', $pwaSettings['name'] ?? 'Taskify')); ?>" required>
                            <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="text-danger small mt-1"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        
                        <div class="col-md-6">
                            <label class="form-label fw-medium" for="short_name">Short Name <span
                                    class="text-danger">*</span></label>
                            <input type="text" name="short_name" id="short_name" class="form-control rounded-3"
                                value="<?php echo e(old('short_name', $pwaSettings['short_name'] ?? 'Taskify')); ?>" required>
                            <?php $__errorArgs = ['short_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="text-danger small mt-1"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        
                        <div class="col-md-6">
                            <label class="form-label fw-medium" for="theme_color">Theme Color<span
                                    class="text-danger">*</span></label>
                            <div class="d-flex align-items-center gap-2">
                                <input type="color" name="theme_color" id="theme_color"
                                    class="form-control form-control-color rounded-3"
                                    value="<?php echo e(old('theme_color', $pwaSettings['theme_color'] ?? '#000000')); ?>" required>
                                <span
                                    class="text-muted small"><?php echo e(old('theme_color', $pwaSettings['theme_color'] ?? '#000000')); ?></span>
                            </div>
                            <?php $__errorArgs = ['theme_color'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="text-danger small mt-1"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        
                        <div class="col-md-6">
                            <label class="form-label fw-medium" for="background_color">Background Color<span
                                    class="text-danger">*</span></label>
                            <div class="d-flex align-items-center gap-2">
                                <input type="color" name="background_color" id="background_color"
                                    class="form-control form-control-color rounded-3"
                                    value="<?php echo e(old('background_color', $pwaSettings['background_color'] ?? '#ffffff')); ?>"
                                    required>
                                <span
                                    class="text-muted small"><?php echo e(old('background_color', $pwaSettings['background_color'] ?? '#ffffff')); ?></span>
                            </div>
                            <?php $__errorArgs = ['background_color'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="text-danger small mt-1"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        
                        <div class="col-12">
                            <label class="form-label fw-medium" for="description">Description <span
                                    class="text-danger">*</span></label>
                            <textarea name="description" id="description" rows="3" class="form-control rounded-3" required><?php echo e(old('description', $pwaSettings['description'] ?? 'A task management app to boost productivity')); ?></textarea>
                            <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="text-danger small mt-1"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        
                        <div class="col-12">
                            <label class="form-label fw-medium" for="logo">Logo <span
                                    class="text-danger">*</span></label>
                            <p class="text-danger small mb-2">Please upload minimum <strong>512x512 PNG</strong> logo or
                                else it will not work.</p>

                            <div class="rounded-3 border border-dashed p-4 text-center">
                                <input type="file" name="logo" id="logo" class="form-control text-center"
                                    accept="image/png">
                                <p class="text-muted small mb-0 mt-2">Recommended Size: larger than 512 x 512</p>
                                <p class="text-muted small mt-1">Current:
                                    <code><?php echo e($pwaSettings['logo'] ?? '/images/icons/logo-512x512.png'); ?></code></p>
                            </div>

                            <?php $__errorArgs = ['logo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="text-danger small mt-1"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        
                        <div class="col-12 d-flex justify-content-end gap-2 pt-3">
                           <button type="button" class="btn btn-outline-dark rounded-3" onclick="resetForm()">Reset</button>
                            <button type="submit" class="btn btn-primary rounded-3 fw-semibold">Update Settings</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>

    </div>

    <script src="<?php echo e(asset('assets/js/pages/pwa-settings.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/capoit/apps.capo.it.com/resources/views/pwa/index.blade.php ENDPATH**/ ?>