<?php
    use App\Models\Workspace;
    use Spatie\Permission\Models\Role;

    $auth_user = getAuthenticatedUser();
    $roles = Role::where('name', '!=', 'admin')->get();
    $isAdminOrHasAllDataAccess = isAdminOrHasAllDataAccess();
    $guard = getGuardName();
?>
<?php if(
    (Request::is('projects*') && !Request::is('projects/information/*')) ||
        Request::is('home') ||
        Request::is('users/profile/*') ||
        Request::is('clients/profile/*')): ?>

    <?php if (isset($component)) { $__componentOriginal14b18b983f87060dbc46dfd126e893ce = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal14b18b983f87060dbc46dfd126e893ce = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.ui.offcanvas','data' => ['id' => 'create_project_offcanvas','title' => ''.e(get_label('create_project', 'Create Project')).'','size' => 'offcanvas-responsive','icon' => 'bx bx-plus','formId' => 'create_project_form','formAction' => url('projects/store'),'formMethod' => 'POST','submitLabel' => get_label('create', 'Create'),'submitIcon' => 'bx bx-check','closeLabel' => get_label('close', 'Close'),'closeIcon' => 'bx bx-x']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('ui.offcanvas'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['id' => 'create_project_offcanvas','title' => ''.e(get_label('create_project', 'Create Project')).'','size' => 'offcanvas-responsive','icon' => 'bx bx-plus','form-id' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute('create_project_form'),'form-action' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(url('projects/store')),'form-method' => 'POST','submit-label' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(get_label('create', 'Create')),'submit-icon' => 'bx bx-check','close-label' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(get_label('close', 'Close')),'close-icon' => 'bx bx-x']); ?>
        <?php if(
            !Request::is('projects') &&
                !Request::is('projects/kanban') &&
                !Request::is('projects/favorite') &&
                !Request::is('projects/kanban/favorite') &&
                !Request::is('projects/gantt-chart') &&
                !Request::is('projects/gantt-chart/favorite')): ?>
            <input type="hidden" name="dnr">
            <input type="hidden" name="table" value="projects_table">
        <?php endif; ?>
        <input type="hidden" name="is_favorite" id="is_favorite" value="0">

        <div class="ai-wrapper">
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label for="title" class="form-label"><?= get_label('title', 'Title') ?> <span
                            class="asterisk">*</span></label>
                    <input class="form-control ai-title" type="text" name="title"
                        placeholder="<?= get_label('please_enter_title', 'Please enter title') ?>"
                        value="<?php echo e(old('title')); ?>">
                </div>
                <div class="col-md-6 mb-3">
                    <label class="form-label" for="status"><?= get_label('status', 'Status') ?> <span
                            class="asterisk">*</span></label>
                    <select class="form-control statusDropdown" name="status_id">
                        <?php if(isset($statuses)): ?>
                            <?php $__currentLoopData = $statuses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if(canSetStatus($status)): ?>
                                    <option value="<?php echo e($status->id); ?>" data-color="<?php echo e($status->color); ?>"
                                        <?php echo e(old('status') == $status->id ? 'selected' : ''); ?>>
                                        <?php echo e($status->title); ?></option>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </select>
                    <div class="mt-2">
                        <a href="javascript:void(0);" class="openCreateStatusModal"><button type="button"
                                class="btn btn-sm btn-primary action_create_statuses" data-bs-toggle="tooltip"
                                data-bs-placement="right"
                                data-bs-original-title=" <?= get_label('create_status', 'Create status') ?>"><i
                                    class="bx bx-plus"></i></button></a>
                        <a href="<?php echo e(url('status/manage')); ?>"><button type="button"
                                class="btn btn-sm btn-primary action_manage_statuses" data-bs-toggle="tooltip"
                                data-bs-placement="right"
                                data-bs-original-title="<?= get_label('manage_statuses', 'Manage statuses') ?>"><i
                                    class="bx bx-list-ul"></i></button></a>
                    </div>
                </div>
                <div class="col-md-6 mb-3">
                    <label class="form-label"><?= get_label('priority', 'Priority') ?></label>
                    <select class="form-select priorityDropdown" name="priority_id"
                        data-placeholder="<?= get_label('please_select', 'Please select') ?>">
                        <option></option>
                        <?php if(isset($priorities)): ?>
                            <?php $__currentLoopData = $priorities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $priority): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($priority->id); ?>" data-color="<?php echo e($priority->color); ?>">
                                    <?php echo e($priority->title); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </select>
                    <div class="mt-2">
                        <a href="javascript:void(0);" class="openCreatePriorityModal"><button type="button"
                                class="btn btn-sm btn-primary action_create_priorities" data-bs-toggle="tooltip"
                                data-bs-placement="right"
                                data-bs-original-title=" <?= get_label('create_priority', 'Create Priority') ?>"><i
                                    class="bx bx-plus"></i></button></a>
                        <a href="<?php echo e(url('priority/manage')); ?>"><button type="button"
                                class="btn btn-sm btn-primary action_manage_priorities" data-bs-toggle="tooltip"
                                data-bs-placement="right"
                                data-bs-original-title="<?= get_label('manage_priorities', 'Manage Priorities') ?>"><i
                                    class="bx bx-list-ul"></i></button></a>
                    </div>
                </div>
                <div class="col-md-6 mb-3">
                    <label for="budget" class="form-label"><?= get_label('budget', 'Budget') ?></label>
                    <div class="input-group input-group-merge">
                        <span class="input-group-text"><?php echo e($general_settings['currency_symbol']); ?></span>
                        <input class="form-control currency" type="text" id="budget" name="budget"
                            placeholder="<?= get_label('please_enter_budget', 'Please enter budget') ?>"
                            value="<?php echo e(old('budget')); ?>">
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label class="form-label" for="start_date"><?= get_label('starts_at', 'Starts at') ?></label>
                    <input type="text" id="start_date" name="start_date" class="form-control"
                        placeholder="<?php echo e(get_label('please_select', 'Please Select')); ?>" autocomplete="off">
                </div>
                <div class="col-md-6 mb-3">
                    <label class="form-label" for="due_date"><?= get_label('ends_at', 'Ends at') ?></label>
                    <input type="text" id="end_date" name="end_date" class="form-control"
                        placeholder="<?php echo e(get_label('please_select', 'Please Select')); ?>" autocomplete="off">
                </div>
            </div>
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label class="form-label" for="">
                        <?= get_label('task_accessibility', 'Task Accessibility') ?>
                        <i class='bx bx-info-circle text-primary' data-bs-toggle="tooltip" data-bs-offset="0,4"
                            data-bs-placement="top" data-bs-html="true" title=""
                            data-bs-original-title="<b><?php echo e(get_label('assigned_users', 'Assigned Users')); ?>:</b> <?php echo e(get_label('assigned_users_info', 'You Will Need to Manually Select Task Users When Creating Tasks Under This Project.')); ?> <br><b><?php echo e(get_label('project_users', 'Project Users')); ?>:</b> <?php echo e(get_label('project_users_info', 'When Creating Tasks Under This Project, the Task Users Selection Will Be Automatically Filled With Project Users.')); ?>"
                            data-bs-toggle="tooltip" data-bs-placement="top"></i>
                    </label>
                    <select class="form-select" name="task_accessibility">
                        <option value="assigned_users"><?= get_label('assigned_users', 'Assigned Users') ?>
                        </option>
                        <option value="project_users"><?= get_label('project_users', 'Project Users') ?>
                        </option>
                    </select>
                </div>
                <?php if($isAdminOrHasAllDataAccess): ?>
                    <div class="col-md-6 mb-3">
                        <label class="form-check-label"
                            for="clientCanDiscussProject"><?php echo e(get_label('client_can_discuss', 'Client Can Discuss')); ?>?</label>
                        <i class='bx bx-info-circle text-primary' data-bs-toggle="tooltip" data-bs-placement="top"
                            title="<?php echo e(get_label('client_can_discuss_info', 'Allows the client to participate in project discussions.')); ?>"></i>
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" id="clientCanDiscussProject"
                                name="clientCanDiscuss">
                        </div>
                    </div>

                    <div class="col-md-6 mb-3">
                        <label class="form-label" for="tasksTimeEntriesSwitch">
                            <?= get_label('tasks_time_entries', 'Tasks Time Entries') ?>
                            <i class="bx bx-info-circle text-primary" data-bs-toggle="tooltip" data-bs-offset="0,4"
                                data-bs-placement="top" data-bs-html="true" title=""
                                data-bs-original-title="<b><?php echo e(get_label('tasks_time_entries', 'Tasks Time Entries')); ?>:</b> <?php echo e(get_label('tasks_time_entries_info', 'To use Time Entries in tasks, you need to enable this option. It allows time tracking and entry management for tasks under this project.')); ?>">
                            </i>
                        </label>
                        <div class="form-check form-switch">
                            <input type="hidden" name="enable_tasks_time_entries" value="0">
                            <input class="form-check-input" type="checkbox" name="enable_tasks_time_entries"
                                id="edit_tasks_time_entries" value="1">
                            <label class="form-check-label" for="tasksTimeEntriesSwitch">
                                <?= get_label('enable', 'Enable') ?>
                            </label>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
            <div class="row">
                <div class="mb-3">
                    <label class="form-label" for="user_id"><?= get_label('select_users', 'Select users') ?></label>
                    <select class="form-control users_select" name="user_id[]" multiple="multiple"
                        data-placeholder="<?= get_label('type_to_search', 'Type to search') ?>">
                        <?php if($guard == 'web'): ?>
                            <option value="<?php echo e($auth_user->id); ?>" selected><?php echo e($auth_user->first_name); ?>

                                <?php echo e($auth_user->last_name); ?></option>
                        <?php endif; ?>
                    </select>
                </div>
            </div>
            <div class="row">
                <div class="mb-3">
                    <label class="form-label"
                        for="client_id"><?= get_label('select_clients', 'Select clients') ?></label>
                    <select class="form-control clients_select" name="client_id[]" multiple="multiple"
                        data-placeholder="<?= get_label('type_to_search', 'Type to search') ?>">
                        <?php if($guard == 'client'): ?>
                            <option value="<?php echo e($auth_user->id); ?>" selected><?php echo e($auth_user->first_name); ?>

                                <?php echo e($auth_user->last_name); ?></option>
                        <?php endif; ?>
                    </select>
                </div>
            </div>
            <div class="row">
                <div class="col-md-12 mb-3">
                    <label class="form-label" for=""><?= get_label('select_tags', 'Select tags') ?></label>
                    <select class="form-control tags_select" name="tag_ids[]" multiple="multiple"
                        data-placeholder="<?= get_label('type_to_search', 'Type to search') ?>">
                    </select>
                    <div class="mt-2">
                        <a href="javascript:void(0);" class="openCreateTagModal"><button type="button"
                                class="btn btn-sm btn-primary action_create_tags" data-bs-toggle="tooltip"
                                data-bs-placement="right"
                                data-bs-original-title=" <?= get_label('create_tag', 'Create tag') ?>"><i
                                    class="bx bx-plus"></i></button></a>
                        <a href="<?php echo e(url('tags/manage')); ?>"><button type="button"
                                class="btn btn-sm btn-primary action_manage_tags" data-bs-toggle="tooltip"
                                data-bs-placement="right"
                                data-bs-original-title="<?= get_label('manage_tags', 'Manage tags') ?>"><i
                                    class="bx bx-list-ul"></i></button></a>
                    </div>
                </div>
            </div>
            <div class="row align-items-center mb-2">
                <!-- Description Label -->
                <div class="col-md-6">
                    <label for="description" class="form-label mb-0">
                        <?= get_label('description', 'Description') ?>
                    </label>
                </div>

                <!-- Custom Prompt Switch + Generate Button -->
                <div class="col-md-6 text-md-end mt-md-0 mt-2">
                    <div class="d-inline-flex align-items-center">
                        <div class="form-check form-switch me-3">
                            <input class="form-check-input enableCustomPrompt" type="checkbox">
                            <label class="form-check-label" for="enableCustomPrompt">
                                <?= get_label('use_custom_prompt', 'Use Custom Prompt') ?>
                            </label>
                        </div>

                        <button type="button" class="btn btn-outline-primary generate-ai btn-sm">
                            <i class="fas fa-magic me-1"></i>
                            <?= get_label('generate_with_ai', 'Generate with AI') ?>
                        </button>

                        <i class="bx bx-info-circle text-primary ms-2" data-bs-toggle="tooltip" data-bs-offset="0,4"
                            data-bs-placement="top" data-bs-html="true" title=""
                            data-bs-original-title="<b><?php echo e(get_label('generate_with_ai', 'Generate with AI')); ?>:</b> <?php echo e(get_label('generate_with_ai_info', 'Enable custom prompt to write your own AI prompt. If disabled, the AI will use the title to generate the description. Max 255 characters will be used.')); ?>">
                        </i>

                        <div class="spinner-border text-primary ai-loader d-none w-px-20 h-px-20 ms-2" role="status">
                            <span class="visually-hidden">Loading...</span>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Custom Prompt Input (initially hidden) -->
            <div class="customPromptContainer d-none mb-2 mt-2">
                <textarea class="form-control ai-custom-prompt" rows="2"
                    placeholder="<?= get_label('enter_custom_prompt', 'Enter custom prompt for AI generation') ?>"></textarea>
            </div>

            <!-- Description Textarea -->
            <div class="mb-3">
                <textarea class="form-control description ai-output" rows="5" name="description"
                    placeholder="<?= get_label('please_enter_description', 'Please enter description') ?>"><?= old('description') ?></textarea>
            </div>
            <div class="row">
                <div class="mb-3">
                    <label class="form-label"><?= get_label('note', 'Note') ?></label>
                    <textarea class="form-control" name="note" rows="3"
                        placeholder="<?= get_label('optional_note', 'Optional Note') ?>"></textarea>
                </div>
            </div>
            <?php
                $isEdit = true;
            ?>
            <!-- Custom Fields Section -->
            <?php if (isset($component)) { $__componentOriginal08fb32409d907753af2039acaeea58af = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal08fb32409d907753af2039acaeea58af = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.custom-fields','data' => ['isEdit' => $isEdit,'fields' => $projectCustomFields]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('custom-fields'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['isEdit' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($isEdit),'fields' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($projectCustomFields)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal08fb32409d907753af2039acaeea58af)): ?>
<?php $attributes = $__attributesOriginal08fb32409d907753af2039acaeea58af; ?>
<?php unset($__attributesOriginal08fb32409d907753af2039acaeea58af); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal08fb32409d907753af2039acaeea58af)): ?>
<?php $component = $__componentOriginal08fb32409d907753af2039acaeea58af; ?>
<?php unset($__componentOriginal08fb32409d907753af2039acaeea58af); ?>
<?php endif; ?>

            <?php if(!$isAdminOrHasAllDataAccess): ?>
                <div class="alert alert-primary" role="alert">
                    <?= get_label('you_will_be_project_participant_automatically', 'You will be project participant automatically.') ?>
                </div>
            <?php endif; ?>
        </div>
     <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal14b18b983f87060dbc46dfd126e893ce)): ?>
<?php $attributes = $__attributesOriginal14b18b983f87060dbc46dfd126e893ce; ?>
<?php unset($__attributesOriginal14b18b983f87060dbc46dfd126e893ce); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal14b18b983f87060dbc46dfd126e893ce)): ?>
<?php $component = $__componentOriginal14b18b983f87060dbc46dfd126e893ce; ?>
<?php unset($__componentOriginal14b18b983f87060dbc46dfd126e893ce); ?>
<?php endif; ?>
<?php endif; ?>

<?php if(Request::is('projects*') ||
        Request::is('home') ||
        Request::is('users/profile/*') ||
        Request::is('clients/profile/*') ||
        Request::is('users') ||
        Request::is('clients')): ?>

    <?php if (isset($component)) { $__componentOriginal14b18b983f87060dbc46dfd126e893ce = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal14b18b983f87060dbc46dfd126e893ce = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.ui.offcanvas','data' => ['id' => 'edit_project_offcanvas','title' => ''.e(get_label('update_project', 'Update Project')).'','size' => 'offcanvas-responsive','icon' => 'bx bx-edit','formId' => 'edit_project_form','formAction' => url('projects/update'),'formMethod' => 'POST','submitLabel' => get_label('update', 'Update'),'submitIcon' => 'bx bx-check','closeLabel' => get_label('close', 'Close'),'closeIcon' => 'bx bx-x']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('ui.offcanvas'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['id' => 'edit_project_offcanvas','title' => ''.e(get_label('update_project', 'Update Project')).'','size' => 'offcanvas-responsive','icon' => 'bx bx-edit','form-id' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute('edit_project_form'),'form-action' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(url('projects/update')),'form-method' => 'POST','submit-label' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(get_label('update', 'Update')),'submit-icon' => 'bx bx-check','close-label' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(get_label('close', 'Close')),'close-icon' => 'bx bx-x']); ?>

        <input type="hidden" name="id" id="project_id">
        <?php if(
            !Request::is([
                'projects',
                'projects/information/*',
                'projects/kanban',
                'projects/favorite',
                'projects/kanban/favorite',
                'projects/gantt-chart/favorite',
            ])): ?>
            <input type="hidden" name="dnr">
            <input type="hidden" name="table" value="projects_table">
        <?php endif; ?>

        <?php echo csrf_field(); ?>
        <div class="ai-wrapper">
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label for="title" class="form-label"><?= get_label('title', 'Title') ?> <span
                            class="asterisk">*</span></label>
                    <input class="form-control ai-title" type="text" name="title" id="project_title"
                        placeholder="<?= get_label('please_enter_title', 'Please enter title') ?>"
                        value="<?php echo e(old('title')); ?>">
                </div>
                <div class="col-md-6 mb-3">
                    <label class="form-label" for="status"><?= get_label('status', 'Status') ?> <span
                            class="asterisk">*</span></label>
                    <select class="form-control statusDropdown" name="status_id" id="project_status_id">
                        <?php if(isset($statuses)): ?>
                            <?php $__currentLoopData = $statuses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($status->id); ?>" data-color="<?php echo e($status->color); ?>"
                                    <?php echo e(old('status') == $status->id ? 'selected' : ''); ?>><?php echo e($status->title); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </select>
                    <div class="mt-2">
                        <a href="javascript:void(0);" class="openCreateStatusModal"><button type="button"
                                class="btn btn-sm btn-primary action_create_statuses" data-bs-toggle="tooltip"
                                data-bs-placement="right"
                                data-bs-original-title=" <?= get_label('create_status', 'Create status') ?>"><i
                                    class="bx bx-plus"></i></button></a>
                        <a href="<?php echo e(url('status/manage')); ?>"><button type="button"
                                class="btn btn-sm btn-primary action_manage_statuses" data-bs-toggle="tooltip"
                                data-bs-placement="right"
                                data-bs-original-title="<?= get_label('manage_statuses', 'Manage statuses') ?>"><i
                                    class="bx bx-list-ul"></i></button></a>
                    </div>
                </div>
                <div class="col-md-6 mb-3">
                    <label class="form-label"><?= get_label('priority', 'Priority') ?></label>
                    <select class="form-select priorityDropdown" name="priority_id" id="project_priority_id"
                        data-placeholder="<?= get_label('please_select', 'Please select') ?>">
                        <option></option>
                        <?php if(isset($priorities)): ?>
                            <?php $__currentLoopData = $priorities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $priority): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($priority->id); ?>" data-color="<?php echo e($priority->color); ?>">
                                    <?php echo e($priority->title); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </select>
                    <div class="mt-2">
                        <a href="javascript:void(0);" class="openCreatePriorityModal"><button type="button"
                                class="btn btn-sm btn-primary action_create_priorities" data-bs-toggle="tooltip"
                                data-bs-placement="right"
                                data-bs-original-title=" <?= get_label('create_priority', 'Create Priority') ?>"><i
                                    class="bx bx-plus"></i></button></a>
                        <a href="<?php echo e(url('priority/manage')); ?>"><button type="button"
                                class="btn btn-sm btn-primary action_manage_priorities" data-bs-toggle="tooltip"
                                data-bs-placement="right"
                                data-bs-original-title="<?= get_label('manage_priorities', 'Manage Priorities') ?>"><i
                                    class="bx bx-list-ul"></i></button></a>
                    </div>
                </div>
                <div class="col-md-6 mb-3">
                    <label for="budget" class="form-label"><?= get_label('budget', 'Budget') ?></label>
                    <div class="input-group input-group-merge">
                        <span class="input-group-text"><?php echo e($general_settings['currency_symbol']); ?></span>
                        <input class="form-control currency" type="text" id="project_budget" name="budget"
                            placeholder="<?= get_label('please_enter_budget', 'Please enter budget') ?>"
                            value="<?php echo e(old('budget')); ?>">
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label class="form-label" for="start_date"><?= get_label('starts_at', 'Starts at') ?></label>
                    <input type="text" id="update_start_date" name="start_date" class="form-control"
                        placeholder="<?php echo e(get_label('please_select', 'Please Select')); ?>" autocomplete="off">
                </div>
                <div class="col-md-6 mb-3">
                    <label class="form-label" for="due_date"><?= get_label('ends_at', 'Ends at') ?></label>
                    <input type="text" id="update_end_date" name="end_date" class="form-control"
                        placeholder="<?php echo e(get_label('please_select', 'Please Select')); ?>" autocomplete="off">
                </div>
            </div>
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label class="form-label" for="">
                        <?= get_label('task_accessibility', 'Task Accessibility') ?>
                        <i class='bx bx-info-circle text-primary' data-bs-toggle="tooltip" data-bs-offset="0,4"
                            data-bs-placement="top" data-bs-html="true" title=""
                            data-bs-original-title="<b><?php echo e(get_label('assigned_users', 'Assigned Users')); ?>:</b> <?php echo e(get_label('assigned_users_info', 'You Will Need to Manually Select Task Users When Creating Tasks Under This Project.')); ?><br><b><?php echo e(get_label('project_users', 'Project Users')); ?>:</b> <?php echo e(get_label('project_users_info', 'When Creating Tasks Under This Project, the Task Users Selection Will Be Automatically Filled With Project Users.')); ?>"
                            data-bs-toggle="tooltip" data-bs-placement="top"></i>
                    </label>
                    <select class="form-select" name="task_accessibility" id="task_accessibility">
                        <option value="assigned_users"><?= get_label('assigned_users', 'Assigned Users') ?>
                        </option>
                        <option value="project_users"><?= get_label('project_users', 'Project Users') ?>
                        </option>
                    </select>
                </div>
                <?php if($isAdminOrHasAllDataAccess): ?>
                    <div class="col-md-6 mb-3">
                        <label class="form-check-label"
                            for="updateClientCanDiscussProject"><?php echo e(get_label('client_can_discuss', 'Client Can Discuss')); ?>?</label>
                        <i class='bx bx-info-circle text-primary' data-bs-toggle="tooltip" data-bs-placement="top"
                            title="<?php echo e(get_label('client_can_discuss_info', 'Allows the client to participate in project discussions.')); ?>"></i>
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" id="updateClientCanDiscussProject"
                                name="clientCanDiscuss">
                        </div>
                    </div>

                    <div class="col-md-6 mb-3">
                        <label class="form-label" for="tasksTimeEntriesSwitch">
                            <?= get_label('tasks_time_entries', 'Tasks Time Entries') ?>
                            <i class="bx bx-info-circle text-primary" data-bs-toggle="tooltip" data-bs-offset="0,4"
                                data-bs-placement="top" data-bs-html="true" title=""
                                data-bs-original-title="<b><?php echo e(get_label('tasks_time_entries', 'Tasks Time Entries')); ?>:</b> <?php echo e(get_label('tasks_time_entries_info', 'To use Time Entries in tasks, you need to enable this option. It allows time tracking and entry management for tasks under this project.')); ?>">
                            </i>
                        </label>
                        <div class="form-check form-switch">
                            <input type="hidden" name="enable_tasks_time_entries" value="0">
                            <input class="form-check-input" type="checkbox" name="enable_tasks_time_entries"
                                id="tasks_time_entries" value="1"
                                <?php echo e(old('tasks_time_entries') ? 'checked' : ''); ?>>
                            <label class="form-check-label" for="tasksTimeEntriesSwitch">
                                <?php echo e(get_label('enable', 'Enable')); ?>

                            </label>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
            <div class="row">
                <div class="mb-3">
                    <label class="form-label" for="user_id"><?= get_label('select_users', 'Select users') ?></label>
                    <select class="form-control users_select" name="user_id[]" multiple="multiple"
                        data-placeholder="<?= get_label('type_to_search', 'Type to search') ?>">
                    </select>
                </div>
            </div>
            <div class="row">
                <div class="mb-3">
                    <label class="form-label"
                        for="client_id"><?= get_label('select_clients', 'Select clients') ?></label>
                    <select class="form-control clients_select" name="client_id[]" multiple="multiple"
                        data-placeholder="<?= get_label('type_to_search', 'Type to search') ?>">
                    </select>
                </div>
            </div>
            <div class="row">
                <div class="col-md-12 mb-3">
                    <label class="form-label" for=""><?= get_label('select_tags', 'Select tags') ?></label>
                    <select class="form-control tags_select" name="tag_ids[]" multiple="multiple"
                        data-placeholder="<?= get_label('type_to_search', 'Type to search') ?>">
                    </select>
                    <div class="mt-2">
                        <a href="javascript:void(0);" class="openCreateTagModal"><button type="button"
                                class="btn btn-sm btn-primary action_create_tags" data-bs-toggle="tooltip"
                                data-bs-placement="right"
                                data-bs-original-title=" <?= get_label('create_tag', 'Create tag') ?>"><i
                                    class="bx bx-plus"></i></button></a>
                        <a href="<?php echo e(url('tags/manage')); ?>"><button type="button"
                                class="btn btn-sm btn-primary action_manage_tags" data-bs-toggle="tooltip"
                                data-bs-placement="right"
                                data-bs-original-title="<?= get_label('manage_tags', 'Manage tags') ?>"><i
                                    class="bx bx-list-ul"></i></button></a>
                    </div>
                </div>
            </div>
            <div class="row align-items-center mb-2">
                <!-- Description Label -->
                <div class="col-md-6">
                    <label for="description" class="form-label mb-0">
                        <?= get_label('description', 'Description') ?>
                    </label>
                </div>

                <!-- Custom Prompt Switch + Generate Button -->
                <div class="col-md-6 text-md-end mt-md-0 mt-2">
                    <div class="d-inline-flex align-items-center">
                        <div class="form-check form-switch me-3">
                            <input class="form-check-input enableCustomPrompt" type="checkbox">
                            <label class="form-check-label" for="enableCustomPrompt">
                                <?= get_label('use_custom_prompt', 'Use Custom Prompt') ?>
                            </label>
                        </div>
                        <button type="button" class="btn btn-outline-primary generate-ai btn-sm">
                            <i class="fas fa-magic me-1"></i>
                            <?= get_label('generate_with_ai', 'Generate with AI') ?>
                        </button>

                        <i class="bx bx-info-circle text-primary ms-2" data-bs-toggle="tooltip" data-bs-offset="0,4"
                            data-bs-placement="top" data-bs-html="true" title=""
                            data-bs-original-title="<b><?php echo e(get_label('generate_with_ai', 'Generate with AI')); ?>:</b> <?php echo e(get_label('generate_with_ai_info', 'Enable custom prompt to write your own AI prompt. If disabled, the AI will use the title to generate the description. Max 255 characters will be used.')); ?>">
                        </i>

                        <div class="spinner-border text-primary ai-loader d-none w-px-20 h-px-20 ms-2" role="status">
                            <span class="visually-hidden">Loading...</span>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Custom Prompt Input (initially hidden) -->
            <div class="customPromptContainer d-none mb-2 mt-2">
                <textarea class="form-control ai-custom-prompt" rows="2"
                    placeholder="<?= get_label('enter_custom_prompt', 'Enter custom prompt for AI generation') ?>"></textarea>
            </div>

            <!-- Description Textarea -->
            <div class="mb-3">
                <textarea class="form-control description ai-output" rows="5" name="description" id="project_description"
                    placeholder="<?= get_label('please_enter_description', 'Please enter description') ?>"><?= old('description') ?></textarea>
            </div>
            <div class="row">
                <div class="mb-3">
                    <label class="form-label"><?= get_label('note', 'Note') ?></label>
                    <textarea class="form-control" name="note" id="projectNote" rows="3"
                        placeholder="<?= get_label('optional_note', 'Optional Note') ?>"></textarea>
                </div>
            </div>
            <?php
                $isEdit = true;
            ?>
            <!-- Custom Fields Section -->
            <?php if (isset($component)) { $__componentOriginal08fb32409d907753af2039acaeea58af = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal08fb32409d907753af2039acaeea58af = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.custom-fields','data' => ['isEdit' => $isEdit,'fields' => $projectCustomFields]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('custom-fields'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['isEdit' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($isEdit),'fields' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($projectCustomFields)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal08fb32409d907753af2039acaeea58af)): ?>
<?php $attributes = $__attributesOriginal08fb32409d907753af2039acaeea58af; ?>
<?php unset($__attributesOriginal08fb32409d907753af2039acaeea58af); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal08fb32409d907753af2039acaeea58af)): ?>
<?php $component = $__componentOriginal08fb32409d907753af2039acaeea58af; ?>
<?php unset($__componentOriginal08fb32409d907753af2039acaeea58af); ?>
<?php endif; ?>
        </div>
     <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal14b18b983f87060dbc46dfd126e893ce)): ?>
<?php $attributes = $__attributesOriginal14b18b983f87060dbc46dfd126e893ce; ?>
<?php unset($__attributesOriginal14b18b983f87060dbc46dfd126e893ce); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal14b18b983f87060dbc46dfd126e893ce)): ?>
<?php $component = $__componentOriginal14b18b983f87060dbc46dfd126e893ce; ?>
<?php unset($__componentOriginal14b18b983f87060dbc46dfd126e893ce); ?>
<?php endif; ?>
<?php endif; ?>
<?php /**PATH /home/capoit/apps.capo.it.com/resources/views/offcanvas.blade.php ENDPATH**/ ?>