
<?php $__env->startSection('title'); ?>
    <?php if($is_favorites == 1): ?>
        <?php echo e(get_label('favorite', 'Favorite')); ?>

    <?php endif; ?>
    <?= get_label('tasks', 'Tasks') ?> - <?= get_label('list_view', 'List view') ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="container-fluid">
        <div class="d-flex justify-content-between mb-2 mt-4">
            <div>
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb breadcrumb-style1">
                        <li class="breadcrumb-item">
                            <a href="<?php echo e(url('home')); ?>"><?= get_label('home', 'Home') ?></a>
                        </li>
                        <?php if(isset($project->id)): ?>
                            <li class="breadcrumb-item">
                                <a
                                    href="<?php echo e(url(getUserPreferences('projects', 'default_view'))); ?>"><?= get_label('projects', 'Projects') ?></a>
                            </li>
                            <li class="breadcrumb-item">
                                <a href="<?php echo e(url('projects/information/' . $project->id)); ?>"><?php echo e($project->title); ?></a>
                            </li>
                        <?php endif; ?>
                        <li class="breadcrumb-item"><?= get_label('tasks', 'Tasks') ?></li>
                        <?php if($is_favorites == 1): ?>
                            <li class="breadcrumb-item"><?= get_label('favorite', 'Favorite') ?></li>
                        <?php endif; ?>
                        <li class="breadcrumb-item active">
                            <?= get_label('list', 'List') ?>
                        </li>
                    </ol>
                </nav>
            </div>
            <div>
                <?php
                    $taskDefaultView = getUserPreferences('tasks', 'default_view');
                ?>
                <?php if(!$taskDefaultView || $taskDefaultView === 'tasks'): ?>
                    <span class="badge bg-primary"><?= get_label('default_view', 'Default View') ?></span>
                <?php else: ?>
                    <a href="javascript:void(0);"><span class="badge bg-secondary" id="set-default-view" data-type="tasks"
                            data-view="list"><?= get_label('set_as_default_view', 'Set as Default View') ?></span></a>
                <?php endif; ?>
            </div>
            <div>
                <?php
                    $projectId = isset($project->id)
                        ? $project->id
                        : (request()->has('project')
                            ? request('project')
                            : '');

                    // Base URL logic
                    if ($is_favorites) {
                        $url =
                            isset($project->id) || request()->has('project')
                                ? url('/projects/tasks/draggable')
                                : url('/tasks/draggable');
                    } else {
                        $url =
                            isset($project->id) || request()->has('project')
                                ? url('/projects/tasks/draggable/' . $projectId)
                                : url('/tasks/draggable');
                    }

                    // Collect query parameters
                    $queryParams = [];
                    if (request()->has('status')) {
                        $queryParams['status'] = request('status');
                    }
                    if ($is_favorites) {
                        $queryParams['favorite'] = 1;
                    }

                    // Append query parameters to the URL
                    if (!empty($queryParams)) {
                        $url .= '?' . http_build_query($queryParams);
                    }
                ?>


                <a href="javascript:void(0);" data-bs-toggle="modal" data-bs-target="#create_task_modal"><button
                        type="button" class="btn btn-sm btn-primary action_create_tasks" data-bs-toggle="tooltip"
                        data-bs-placement="right"
                        data-bs-original-title=" <?= get_label('create_task', 'Create task') ?>"><i
                            class="bx bx-plus"></i></button></a>
                <a href="<?php echo e($url); ?>"><button type="button" class="btn btn-sm btn-primary" data-bs-toggle="tooltip"
                        data-bs-placement="left"
                        data-bs-original-title="<?= get_label('draggable_view', 'Draggable View') ?>"><i
                            class="bx bxs-dashboard"></i></button></a>
                <a href="<?php echo e(route('tasks.groupByTaskList')); ?>"><button type="button" class="btn btn-sm btn-primary" data-bs-toggle="tooltip"
                    data-bs-placement="left"
                    data-bs-original-title="<?= get_label('group_by_task_list', 'Group By Task List') ?>"><i
                        class="bx bx-align-middle"></i></button></a>
                <?php
                    $projectId = isset($project->id)
                        ? $project->id
                        : (request()->has('project')
                            ? request('project')
                            : '');

                    // Base URL logic
                    if ($is_favorites) {
                        $url =
                            isset($project->id) || request()->has('project')
                                ? url('/projects/tasks/calendar')
                                : url('/tasks/calendar');
                    } else {
                        $url =
                            isset($project->id) || request()->has('project')
                                ? url('/projects/tasks/calendar/' . $projectId)
                                : url('/tasks/calendar');
                    }

                    // Collect query parameters
                    $queryParams = [];
                    if (request()->has('status')) {
                        $queryParams['status'] = request('status');
                    }
                    if ($is_favorites) {
                        $queryParams['favorite'] = 1; // Add favorite=1 when $is_favorites is true
                    }

                    // Append the query parameters to the URL
                    if (!empty($queryParams)) {
                        $url .= '?' . http_build_query($queryParams);
                    }
                ?>


                <a href="<?php echo e($url); ?>"><button type="button" class="btn btn-sm btn-primary" data-bs-toggle="tooltip"
                        data-bs-placement="left"
                        data-bs-original-title="<?= get_label('calendar_view', 'Calendar View') ?>"><i
                            class="bx bx-calendar"></i></button></a>
            </div>
        </div>
        <?php
        $id = isset($project->id) ? 'project_' . $project->id : '';
        ?>
        <?php if (isset($component)) { $__componentOriginal6e07742d54bdaa8ecbb34c156d7ec080 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal6e07742d54bdaa8ecbb34c156d7ec080 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.tasks-card','data' => ['tasks' => $tasks,'id' => $id,'project' => $project,'favorites' => $is_favorites,'customFields' => $taskCustomFields]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('tasks-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['tasks' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($tasks),'id' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($id),'project' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($project),'favorites' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($is_favorites),'customFields' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($taskCustomFields)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal6e07742d54bdaa8ecbb34c156d7ec080)): ?>
<?php $attributes = $__attributesOriginal6e07742d54bdaa8ecbb34c156d7ec080; ?>
<?php unset($__attributesOriginal6e07742d54bdaa8ecbb34c156d7ec080); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal6e07742d54bdaa8ecbb34c156d7ec080)): ?>
<?php $component = $__componentOriginal6e07742d54bdaa8ecbb34c156d7ec080; ?>
<?php unset($__componentOriginal6e07742d54bdaa8ecbb34c156d7ec080); ?>
<?php endif; ?>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/capoit/apps.capo.it.com/resources/views/tasks/tasks.blade.php ENDPATH**/ ?>