<?php

use App\Models\User;
use App\Models\Workspace;
use App\Models\LeaveRequest;
use Chatify\ChatifyMessenger;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;

$user = getAuthenticatedUser();
if (isAdminOrHasAllDataAccess()) {
    $workspaces = Workspace::all()->take(5);
    $total_workspaces = Workspace::count();
} else {
    $workspaces = $user->workspaces;
    $total_workspaces = count($workspaces);
    $workspaces = $user->workspaces->skip(0)->take(5);
}
$current_workspace_id = getWorkspaceId();
$current_workspace = Workspace::find($current_workspace_id);
// Check if the current workspace is in the list of workspaces retrieved
$workspace_ids = $workspaces->pluck('id')->toArray();
if (!in_array($current_workspace_id, $workspace_ids)) {
    // If not, prepend the current workspace to the list
    $current_workspace = Workspace::find($current_workspace_id);
    $workspaces->prepend($current_workspace);
    // If there are more than 5 workspaces, remove the last one
    if ($workspaces->count() > 5) {
        $workspaces->pop();
    }
}
$current_workspace_title = $current_workspace->title ?? 'No workspace(s) found';
$messenger = new ChatifyMessenger();
$unread = $messenger->totalUnseenMessages();
$pending_todos_count = $user->todos(0)->count();
$ongoing_meetings_count = $user->meetings('ongoing')->count();
$query = LeaveRequest::where('status', 'pending')->where('workspace_id', $current_workspace_id);
if (!is_admin_or_leave_editor()) {
    $query->where('user_id', $user->id);
}
$pendingLeaveRequestsCount = $query->count();
?>
<aside id="layout-menu" class="layout-menu menu-vertical menu bg-menu-theme menu-container">
    <div class="app-brand demo">
        <a href="<?php echo e(url('home')); ?>" class="app-brand-link">
            <span class="app-brand-logo demo">
                <img src="<?php echo e(asset($general_settings['full_logo'])); ?>" width="200px" alt="" />
            </span>
            <!-- <span class="app-brand-text demo menu-text fw-bolder ms-2">Taskify</span> -->
        </a>
        <a href="javascript:void(0);" class="layout-menu-toggle menu-link text-large d-block d-xl-none ms-auto">
            <i class="bx bx-chevron-left bx-sm align-middle"></i>
        </a>
    </div>
    <div class="btn-group dropend px-2">
        <button type="button"
            class="btn btn-primary <?php echo e(getAuthenticatedUser()->hasVerifiedEmail() || getAuthenticatedUser()->hasRole('admin') ? 'dropdown-toggle' : ''); ?>"
            data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
            <?php echo e(strlen($current_workspace_title) > 22 ? substr($current_workspace_title, 0, 22) . '...' : $current_workspace_title); ?>

        </button>
        <?php if(getAuthenticatedUser()->hasVerifiedEmail() || getAuthenticatedUser()->hasRole('admin')): ?>
            <ul class="dropdown-menu">
                <?php if($total_workspaces > 0): ?>
                    <?php $__currentLoopData = $workspaces; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $workspace): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php $checked = $workspace->id == $current_workspace_id ? "<i class='menu-icon tf-icons bx bx-check-square text-primary'></i>" : "<i class='menu-icon tf-icons bx bx-square text-solid'></i>"; ?>
                        <li>
                            <a class="dropdown-item" href="<?php echo e(url('/workspaces/switch/' . $workspace->id)); ?>">
                                <?php echo $checked; ?>

                                <?php echo e($workspace->title); ?>

                                
                                <?php if($workspace->is_primary): ?>
                                    <span class="badge bg-success"><?php echo e(get_label('primary', 'Primary')); ?></span>
                                <?php endif; ?>

                                
                                <?php if($user->default_workspace_id == $workspace->id): ?>
                                    <span class="badge bg-primary"><?php echo e(get_label('default', 'Default')); ?></span>
                                <?php endif; ?>

                            </a>
                        </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <li>
                        <hr class="dropdown-divider" />
                    </li>
                <?php endif; ?>
                <?php if($user->can('manage_workspaces')): ?>
                    <li>
                        <a class="dropdown-item" href="<?php echo e(url('workspaces')); ?>">
                            <i class='menu-icon tf-icons bx bx-bar-chart-alt-2 text-success'></i>
                            <?php echo get_label('manage_workspaces', 'Manage workspaces'); ?>

                            <?php echo $total_workspaces > 5 ? '<span class="badge bg-primary"> + ' . ($total_workspaces - 5) . '</span>' : ''; ?>

                        </a>
                    </li>
                    <?php if($user->can('create_workspaces')): ?>
                        <li>
                            <span data-bs-toggle="modal" data-bs-target="#createWorkspaceModal">
                                <a class="dropdown-item" href="javascript:void(0);">
                                    <i class='menu-icon tf-icons bx bx-plus text-warning'></i>
                                    <?php echo get_label('create_workspace', 'Create workspace'); ?>

                                </a>
                            </span>
                        </li>
                    <?php endif; ?>
                    <?php if($user->can('edit_workspaces')): ?>
                        <li>
                            <a class="dropdown-item edit-workspace" href="javascript:void(0);"
                                data-id="<?php echo e(getWorkspaceId()); ?>">
                                <i class='menu-icon tf-icons bx bx-edit text-primary'></i>
                                <?php echo get_label('edit_workspace', 'Edit workspace'); ?>

                            </a>
                        </li>
                    <?php endif; ?>
                <?php endif; ?>
                <?php if($current_workspace): ?>
                    <li>
                        <a class="dropdown-item" href="#" id="remove-participant">
                            <i class='menu-icon tf-icons bx bx-exit text-danger'></i>
                            <?php echo get_label('remove_me_from_workspace', 'Remove me from workspace'); ?>

                        </a>
                    </li>
                <?php endif; ?>
            </ul>
        <?php endif; ?>
    </div>

    <div class="px-2 pt-3">
        <div class="input-group input-group-merge">
            <input type="text" id="menu-search" class="form-control custom-search-input"
                placeholder="<?php echo e(get_label('search_menu', 'Search Menu...')); ?>">
        </div>
    </div>

    <ul class="menu-inner pb-1">
        <hr class="dropdown-divider" />

        <?php
            $menuOrder = json_decode(
                DB::table('menu_orders')
                    ->where(getGuardName() == 'web' ? 'user_id' : 'client_id', getAuthenticatedUser()->id)
                    ->value('menu_order'),
                true,
            );

            $menus = getMenus();
            // dd($menuOrder, $menus);
            $pluginMenus = []; // Initialize safely

            $pluginPath = base_path('plugins');

            if (File::exists($pluginPath)) {
                $pluginDirs = glob($pluginPath . '/*', GLOB_ONLYDIR);

                foreach ($pluginDirs as $pluginDir) {
                    $pluginJsonFile = $pluginDir . '/plugin.json';

                    if (File::exists($pluginJsonFile)) {
                        $pluginData = json_decode(File::get($pluginJsonFile), true);

                        // Check if plugin is enabled
                        if (!empty($pluginData['enabled'])) {
                            $menuFile = $pluginDir . '/menus.php';

                            if (File::exists($menuFile)) {
                                $pluginMenuItems = include $menuFile;

                                if (is_array($pluginMenuItems)) {
                                    $pluginMenus = array_merge($pluginMenus, $pluginMenuItems);
                                }
                            }
                        }
                    }
                }
            }

            // Merge your core menus with plugin menus
            $menus = array_merge($menus, $pluginMenus);
            // Sort menus based on saved order
            $sortedMenus = [];

            if ($menuOrder) {
                foreach ($menuOrder as $categoryData) {
                    // Ensure 'menus' key exists in categoryData
                    if (!isset($categoryData['menus']) || !is_array($categoryData['menus'])) {
                        continue;
                    }

                    foreach ($categoryData['menus'] as $order) {
                        if (!isset($order['id'])) {
                            continue; // Skip if id is missing
                        }

                        // Find menu by ID from $menus
                        $menu = collect($menus)->firstWhere('id', $order['id']);
                        if ($menu) {
                            // Sort submenus if present
                            if (!empty($order['submenus'])) {
                                $submenuIds = collect($order['submenus'])->pluck('id')->toArray();
                                $menu['submenus'] = collect($menu['submenus'] ?? [])
                                    ->whereNotNull('id')
                                    ->sortBy(function ($submenu) use ($submenuIds) {
                                        return array_search($submenu['id'], $submenuIds) ?? PHP_INT_MAX;
                                    })
                                    ->toArray();
                            }

                            $sortedMenus[] = $menu;
                        }
                    }
                }
            } else {
                // Use default order if no saved menu order
                $sortedMenus = $menus;
            }

            // Group menus by category
            $groupedMenus = collect($sortedMenus)->groupBy('category');
        ?>

        <?php $__currentLoopData = $groupedMenus; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category => $menus): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php
                // Filter out empty categories
                $filteredMenus = collect($menus)->filter(function ($menu) {
                    return !isset($menu['show']) || $menu['show'] === 1;
                });
            ?>

            <?php if($filteredMenus->isNotEmpty()): ?>
                <!-- Category Header -->
                <li class="menu-header small text-uppercase">
                    <span class="menu-header-text">
                        <?php echo e(get_label($category, ucfirst(str_replace('_', ' ', $category)))); ?>

                    </span>
                </li>

                <?php $__currentLoopData = $filteredMenus; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $menu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li class="<?php echo e($menu['class']); ?>">
                        <a href="<?php echo e($menu['url'] ?? 'javascript:void(0)'); ?>"
                            class="menu-link <?php echo e(isset($menu['submenus']) ? 'menu-toggle' : ''); ?>">
                            <i class="menu-icon tf-icons <?php echo e($menu['icon']); ?>"></i>
                            <div>
                                <?php echo e($menu['label']); ?>

                                <?php if(isset($menu['badge']) && $menu['badge']): ?>
                                    <?php echo $menu['badge']; ?>

                                <?php endif; ?>
                            </div>
                        </a>

                        <?php if(isset($menu['submenus'])): ?>
                            <ul class="menu-sub">
                                <?php $__currentLoopData = $menu['submenus']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $submenu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if(!isset($submenu['show']) || $submenu['show'] === 1): ?>
                                        <li class="<?php echo e($submenu['class']); ?>">
                                            <a href="<?php echo e($submenu['url']); ?>" class="menu-link">
                                                <div><?php echo e($submenu['label']); ?></div>
                                            </a>
                                        </li>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        <?php endif; ?>
                    </li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </ul>




</aside>
<?php /**PATH /home/capoit/apps.capo.it.com/resources/views/components/menu.blade.php ENDPATH**/ ?>