
<?php $__env->startSection('title'); ?>
    <?= get_label('dashboard', 'Dashboard') ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <?php if (auth('web')->check() || auth('client')->check() || auth()->guard('sanctum')->check()): ?>
    <div class="container-fluid">
        <!-- Alert for Reset Warning -->
        <?php if(config('constants.ALLOW_MODIFICATION') === 0): ?>
            <?php if (isset($component)) { $__componentOriginal1587a26e02f5044e2021410bd7590d74 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal1587a26e02f5044e2021410bd7590d74 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.dashboard.alert','data' => ['type' => 'warning','classes' => 'container mb-0 mt-4','icon' => 'bx bx-timer','message' => 'Important: Data automatically resets every 24 hours!','dismissible' => 'true']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('dashboard.alert'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['type' => 'warning','classes' => 'container mb-0 mt-4','icon' => 'bx bx-timer','message' => 'Important: Data automatically resets every 24 hours!','dismissible' => 'true']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal1587a26e02f5044e2021410bd7590d74)): ?>
<?php $attributes = $__attributesOriginal1587a26e02f5044e2021410bd7590d74; ?>
<?php unset($__attributesOriginal1587a26e02f5044e2021410bd7590d74); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal1587a26e02f5044e2021410bd7590d74)): ?>
<?php $component = $__componentOriginal1587a26e02f5044e2021410bd7590d74; ?>
<?php unset($__componentOriginal1587a26e02f5044e2021410bd7590d74); ?>
<?php endif; ?>
        <?php endif; ?>
        <?php
                $tiles = [
                    'manage_projects' => [
                        'permission' => 'manage_projects',
                        'icon' => 'bx bx-briefcase-alt-2 text-success',
                        'icon-bg' => 'bg-label-success',
                        'label' => get_label('total_projects', 'Total projects'),
                        'count' => is_countable($projects) && count($projects) > 0 ? count($projects) : 0,
                        'url' => url(getUserPreferences('projects', 'default_view')),
                        'link_color' => 'text-success',
                    ],
                    'manage_tasks' => [
                        'permission' => 'manage_tasks',
                        'icon' => 'bx bx-task text-primary',
                        'icon-bg' => 'bg-label-primary',
                        'label' => get_label('total_tasks', 'Total tasks'),
                        'count' => $tasks,
                        'url' => url(getUserPreferences('tasks', 'default_view')),
                        'link_color' => 'text-primary',
                    ],
                    'manage_users' => [
                        'permission' => 'manage_users',
                        'icon' => 'bx bxs-user-detail text-warning',
                        'icon-bg' => 'bg-label-warning',
                        'label' => get_label('total_users', 'Total users'),
                        'count' => is_countable($users) && count($users) > 0 ? count($users) : 0,
                        'url' => url('users'),
                        'link_color' => 'text-warning',
                    ],
                    'manage_clients' => [
                        'permission' => 'manage_clients',
                        'icon' => 'bx bxs-user-detail text-info',
                        'icon-bg' => 'bg-label-info',
                        'label' => get_label('total_clients', 'Total clients'),
                        'count' => is_countable($clients) && count($clients) > 0 ? count($clients) : 0,
                        'url' => url('clients'),
                        'link_color' => 'text-info',
                    ],
                    'manage_meetings' => [
                        'permission' => 'manage_meetings',
                        'icon' => 'bx bx-shape-polygon text-warning',
                        'icon-bg' => 'bg-label-warning',
                        'label' => get_label('total_meetings', 'Total meetings'),
                        'count' => is_countable($meetings) && count($meetings) > 0 ? count($meetings) : 0,
                        'url' => url('meetings'),
                        'link_color' => 'text-warning',
                    ],
                    'total_todos' => [
                        'permission' => null, // No specific permission required
                        'icon' => 'bx bx-list-check text-info',
                        'icon-bg' => 'bg-label-info',
                        'label' => get_label('total_todos', 'Total todos'),
                        'count' => is_countable($total_todos) && count($total_todos) > 0 ? count($total_todos) : 0,
                        'url' => url('todos'),
                        'link_color' => 'text-info',
                    ],
                ];
                // Filter tiles based on user permissions
                $filteredTiles = array_filter($tiles, function ($tile) use ($auth_user) {
                    return !$tile['permission'] || $auth_user->can($tile['permission']);
                });
                // Get the first 4 tiles
                $filteredTiles = array_slice($filteredTiles, 0, 4);
            ?>


        <!-- Tiles Section -->
        <div class="col-lg-12 col-md-12 order-1">

            <div class="row mt-4">
                <?php $__currentLoopData = $filteredTiles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tile): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if (isset($component)) { $__componentOriginalf34dfa62cc452903cbbb893d0b4f12f4 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalf34dfa62cc452903cbbb893d0b4f12f4 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.dashboard.tile','data' => ['label' => $tile['label'],'count' => $tile['count'],'url' => $tile['url'],'linkColor' => $tile['link_color'],'icon' => $tile['icon'],'iconBg' => $tile['icon-bg']]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('dashboard.tile'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['label' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($tile['label']),'count' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($tile['count']),'url' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($tile['url']),'linkColor' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($tile['link_color']),'icon' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($tile['icon']),'iconBg' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($tile['icon-bg'])]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalf34dfa62cc452903cbbb893d0b4f12f4)): ?>
<?php $attributes = $__attributesOriginalf34dfa62cc452903cbbb893d0b4f12f4; ?>
<?php unset($__attributesOriginalf34dfa62cc452903cbbb893d0b4f12f4); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalf34dfa62cc452903cbbb893d0b4f12f4)): ?>
<?php $component = $__componentOriginalf34dfa62cc452903cbbb893d0b4f12f4; ?>
<?php unset($__componentOriginalf34dfa62cc452903cbbb893d0b4f12f4); ?>
<?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
            <!-- Statistics Section -->

            <div class="row">
                <?php if (isset($component)) { $__componentOriginalf4405b99d48cea94f34d50f7e71484ad = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalf4405b99d48cea94f34d50f7e71484ad = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.dashboard.statistics','data' => ['todos' => $todos,'activities' => $activities]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('dashboard.statistics'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['todos' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($todos),'activities' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($activities)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalf4405b99d48cea94f34d50f7e71484ad)): ?>
<?php $attributes = $__attributesOriginalf4405b99d48cea94f34d50f7e71484ad; ?>
<?php unset($__attributesOriginalf4405b99d48cea94f34d50f7e71484ad); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalf4405b99d48cea94f34d50f7e71484ad)): ?>
<?php $component = $__componentOriginalf4405b99d48cea94f34d50f7e71484ad; ?>
<?php unset($__componentOriginalf4405b99d48cea94f34d50f7e71484ad); ?>
<?php endif; ?>
            </div>
            <!-- Tabs Section -->
            <?php if(
                !isClient() &&
                    ($auth_user->can('manage_users') || $auth_user->can('manage_projects') || $auth_user->can('manage_tasks'))): ?>
                <?php if (isset($component)) { $__componentOriginala4f04416a4c274f49839282fb3d14727 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginala4f04416a4c274f49839282fb3d14727 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.dashboard.tabs','data' => ['users' => $users,'projects' => $projects,'tasks' => $tasks]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('dashboard.tabs'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['users' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($users),'projects' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($projects),'tasks' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($tasks)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginala4f04416a4c274f49839282fb3d14727)): ?>
<?php $attributes = $__attributesOriginala4f04416a4c274f49839282fb3d14727; ?>
<?php unset($__attributesOriginala4f04416a4c274f49839282fb3d14727); ?>
<?php endif; ?>
<?php if (isset($__componentOriginala4f04416a4c274f49839282fb3d14727)): ?>
<?php $component = $__componentOriginala4f04416a4c274f49839282fb3d14727; ?>
<?php unset($__componentOriginala4f04416a4c274f49839282fb3d14727); ?>
<?php endif; ?>
            <?php endif; ?>
        </div>
        <!-- ------------------------------------------- -->
        <?php
            $titles = [];
            $project_counts = [];
            $task_counts = [];
            $bg_colors = [];
            $total_projects = 0;
            $total_tasks = 0;
            $total_todos = count($todos);
            $done_todos = 0;
            $pending_todos = 0;
            $todo_counts = [];
            $ran = [
                '#63ed7a',
                '#ffa426',
                '#fc544b',
                '#6777ef',
                '#FF00FF',
                '#53ff1a',
                '#ff3300',
                '#0000ff',
                '#00ffff',
                '#99ff33',
                '#003366',
                '#cc3300',
                '#ffcc00',
                '#ff9900',
                '#3333cc',
                '#ffff00',
                '#FF5733',
                '#33FF57',
                '#5733FF',
                '#FFFF33',
                '#A6A6A6',
                '#FF99FF',
                '#6699FF',
                '#666666',
                '#FF6600',
                '#9900CC',
                '#FF99CC',
                '#FFCC99',
                '#99CCFF',
                '#33CCCC',
                '#CCFFCC',
                '#99CC99',
                '#669999',
                '#CCCCFF',
                '#6666FF',
                '#FF6666',
                '#99CCCC',
                '#993366',
                '#339966',
                '#99CC00',
                '#CC6666',
                '#660033',
                '#CC99CC',
                '#CC3300',
                '#FFCCCC',
                '#6600CC',
                '#FFCC33',
                '#9933FF',
                '#33FF33',
                '#FFFF66',
                '#9933CC',
                '#3300FF',
                '#9999CC',
                '#0066FF',
                '#339900',
                '#666633',
                '#330033',
                '#FF9999',
                '#66FF33',
                '#6600FF',
                '#FF0033',
                '#009999',
                '#CC0000',
                '#999999',
                '#CC0000',
                '#CCCC00',
                '#00FF33',
                '#0066CC',
                '#66FF66',
                '#FF33FF',
                '#CC33CC',
                '#660099',
                '#663366',
                '#996666',
                '#6699CC',
                '#663399',
                '#9966CC',
                '#66CC66',
                '#0099CC',
                '#339999',
                '#00CCCC',
                '#CCCC99',
                '#FF9966',
                '#99FF00',
                '#66FF99',
                '#336666',
                '#00FF66',
                '#3366CC',
                '#CC00CC',
                '#00FF99',
                '#FF0000',
                '#00CCFF',
                '#000000',
                '#FFFFFF',
            ];
            foreach ($statuses as $status) {
                $project_count = isAdminOrHasAllDataAccess()
                    ? count($status->projects)
                    : $auth_user->status_projects($status->id)->count();
                array_push($project_counts, $project_count);
                $task_count = isAdminOrHasAllDataAccess()
                    ? count($status->tasks)
                    : $auth_user->status_tasks($status->id)->count();
                array_push($task_counts, $task_count);
                array_push($titles, "'" . $status->title . "'");
                $v = array_shift($ran);
                array_push($bg_colors, "'" . $v . "'");
                $total_projects += $project_count;
                $total_tasks += $task_count;
            }
            $titles = implode(',', $titles);
            $project_counts = implode(',', $project_counts);
            $task_counts = implode(',', $task_counts);
            $bg_colors = implode(',', $bg_colors);
            foreach ($todos as $todo) {
                $todo->is_completed ? ($done_todos += 1) : ($pending_todos += 1);
            }
            array_push($todo_counts, $done_todos);
            array_push($todo_counts, $pending_todos);
            $todo_counts = implode(',', $todo_counts);
        ?>
        <script>
            var labels = [<?= $titles ?>];
            var project_data = [<?= $project_counts ?>];
            var task_data = [<?= $task_counts ?>];
            var bg_colors = [<?= $bg_colors ?>];
            var total_projects = [<?= $total_projects ?>];
            var total_tasks = [<?= $total_tasks ?>];
            var total_todos = [<?= $total_todos ?>];
            var todo_data = [<?= $todo_counts ?>];
            //labels
            var done = '<?= get_label('done', 'Done') ?>';
            var pending = '<?= get_label('pending', 'Pending') ?>';
            var total = '<?= get_label('total', 'Total') ?>';
        </script>
        <script src="<?php echo e(asset('assets/js/apexcharts.js')); ?>"></script>
        <script src="<?php echo e(asset('assets/js/Sortable.min.js')); ?>"></script>

        <script src="<?php echo e(asset('assets/js/pages/dashboard.js')); ?>"></script>
    <?php else: ?>
        <div class="w-100 h-100 d-flex align-items-center justify-content-center">
            <span>You must <a href="<?php echo e(url('login')); ?>">Log in</a> or <a href="<?php echo e(url('register')); ?>">Register</a> to
                access
                <?php echo e($general_settings['company_title']); ?>!</span>
        </div>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/capoit/apps.capo.it.com/resources/views/dashboard.blade.php ENDPATH**/ ?>